<?php
  require '../connection.php';

  function fetchMySQL($SQL, $CRUD = 'GET', $params = null, $types = null){
    $conn = getConnection();
    $query = $conn->prepare($SQL);
    if($query){
      if($params && count($params)>0){
        if($types){
          $query->bind_param($types, ...$params);
        }else{
          $types = '';
          foreach($params as $p):
            $types .= 's';
          endforeach;
          $query->bind_param($types, ...$params);
        }
      }
      $query->execute();

      if($CRUD=='GET'){ return $query->get_result(); }
      if($CRUD=='POST'){ return $query; }

    }else{ 
      $object = new stdClass();
      $object->num_rows = 0;
      return $object;
    }
  }

  function fetchSQLserv($SQL, $CRUD = 'GET'){
    $conn = getConnection();
    $query = sqlsrv_query($conn, $SQL);
    if(true){
      if($CRUD=='GET'){ return $query->get_result(); }
      if($CRUD=='POST'){ return $query; }

    }else{ 
      $object = new stdClass();
      $object->num_rows = 0;
      return $object;
    }
  }

  function makeResponse($result){
    $success = $result['success'];
    $status  = 400;
    
    if($success){
      $status = 200;
    }else{
      $status = 400;
    }
    
    return array(
      'data'      =>$result['data'],
      'status'    =>$status,
      'errorMsg'  =>$result['errorMsg'],
      'successMsg'=>$result['successMsg'],
    );
  }

?>