<?php
    require_once "../vendor/autoload.php";
    require "../Utils/fetchData.php";
    use Firebase\JWT\JWT;

    function loginUser($user_username, $user_password){
        try{
          $config = include('../config.php');
          $SQL = 
            "SELECT 
              u.usuarioid,
              u.nombre,
              u.dni,
              u.direccion,
              u.telefono,
              u.username,
              u.password,
              u.tipo
            FROM  usuario u
            WHERE u.username = ?";
          $params = array($user_username);

          $result = fetchMySQL($SQL, 'GET', $params);

          $dataToReturn = array();
          $errorMsg     = "";
          $successMsg   = "";
          $success      = false;
          
          if($result->num_rows >= 1){
            foreach ($result as $row):
              $user_password_bd = $row['password'];
              if(password_verify($user_password, $user_password_bd)){
                //Token 
                $secretKey = $config['secretKeyJWT'];
                $time  = time();
                $token = array(
                  "iat"  => $time, 
                  "exp"  => $time + (60*60*24*365),
                  "data" => [
                    'user_id'   =>$row['usuarioid'],
                    'user_name' =>$row['username'],
                    'user_admin'=>$row['tipo']==2
                  ]
                );
                    
                $jwt = JWT::encode($token, $secretKey, 'HS256');
                  
                $datajson = array(
                  'user_id'   =>$row['usuarioid'],
                  'user_name' =>$row['nombre'],
                  'user_tipo' =>$row['tipo'],
                  'user_token'=>$jwt
                );

                $dataToReturn = $datajson;
                $errorMsg   = "";
                $successMsg = 'Bienvenid@';
                $success    = true; 
              }else{
                $dataToReturn = array();
                $errorMsg   ='Contraseña incorrecta';
                $successMsg = "";
                $success    = false;
              }
            endforeach;
          }else{
            $dataToReturn = array();
            $errorMsg   ='El usuario no existe';
            $successMsg = "";
            $success    = false;
          }
          
          return array(
              'data'      =>$dataToReturn,
              'errorMsg'  =>$errorMsg,
              'successMsg'=>$successMsg, 
              'success'   =>$success
          );
        
        }catch(Exception $e){
          return array(
            'data'      =>array(),
            'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
            'successMsg'=>'',
            'success'   =>false
          );
        }
    }
?>