<?php

require '../Utils/fetchData.php';
require_once '../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

//TODO: Archivo de conexion y config con el secretKey

	function verifyToken($auth){
			$config = include('../config.php');
			$url = trim($auth);
			try{
					if (!empty($url)) {
							if (preg_match('/Bearer\s(\S+)/', $url, $matches)){
									$token = $matches[1];
									$secretKey = $config['secretKeyJWT'];
									$decoded = JWT::decode($token, new Key($secretKey, 'HS256'));
									$data_token = $decoded->data;
									return $data_token;                
							}
							else{
									return false;                
							}
					}
					else{
							return false;                
					}
			}catch(Exception $e){
					return false;
			}
	}

	function getCheques($fecha_ini, $fecha_fin){
			try{
					$conn = getConnection();
					$SQL = "
							SELECT 
									ic.[id],
									ic.[cod_sucursal],
									ic.[detalle],
									ic.[fecha],
									ic.[fecha_impresion],
									ic.[monto],
									ic.[monto_letras],
									ic.[nombre],
									ic.[numero_consecutivo]
							FROM  impresion_cheques ic
							WHERE ic.fecha_impresion between '$fecha_ini' and '$fecha_fin'";

					$result = sqlsrv_query($conn, $SQL);

					$dataToReturn = array();
					$errorMsg     = "";
					$successMsg   = "";
					$success      = false;
					$count        = 0;
					$json         = array();

					if( $result === false) {
							return array(
									'data'      =>array(),
									'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
									'successMsg'=>'',
									'success'   =>false
							);
					}
					
					while($row = sqlsrv_fetch_object($result)){
							$count ++;
							if(property_exists($row,'id'          )){ $resultado['id']           = $row->id;};
							if(property_exists($row,'cod_sucursal')){ $resultado['cod_sucursal'] = $row->cod_sucursal;};
							if(property_exists($row,'detalle'     )){ $resultado['detalle']      = $row->detalle;};
							if(property_exists($row,'fecha'       )){ $resultado['fecha']        = $row->fecha;};
							if(property_exists($row,'monto'       )){ $resultado['monto']        = $row->monto;};
							if(property_exists($row,'monto_letras')){ $resultado['monto_letras'] = $row->monto_letras;};
							if(property_exists($row,'nombre'      )){ $resultado['nombre']       = $row->nombre;};

							if(property_exists($row,'fecha_impresion'   )){ $resultado['fecha_impresion']    = $row->fecha_impresion;};
							if(property_exists($row,'numero_consecutivo')){ $resultado['numero_consecutivo'] = $row->numero_consecutivo;};
							
							$json[]=$resultado;
					}

					$dataToReturn = $json;
					$errorMsg     = "";
					$successMsg   = 'Exito';
					$success      = true; 

					if($count == 0) {
							$dataToReturn = array();
							$errorMsg   ='No se encontraron Registros';
							$successMsg = "";
							$success    = false;
					}
					
					return array(
							'data'      =>$dataToReturn,
							'errorMsg'  =>$errorMsg,
							'successMsg'=>$successMsg, 
							'success'   =>$success
					);
			
			}catch(Exception $e){
					return array(
							'data'      =>array(),
							'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
							'successMsg'=>'',
							'success'   =>false
					);
			}
	}

	// USER FUNTIONS -------------------->

	function getUsers(){
			try{
				$SQL = 
					"SELECT 
						u.usuarioid,
						u.username,
						u.nombre,
						u.dni,
						u.direccion,
						u.telefono, 
						u.tipo
					FROM usuario u
					";
					$result = fetchMySQL($SQL);
					
					if(!$result) {
						return array(
							'data'      =>array(),
							'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
							'successMsg'=>'',
							'success'   =>false
						);
					}

					$dataToReturn = array();
					$errorMsg     = "";
					$successMsg   = "";
					$success      = false;
					$count        = $result->num_rows;
					$json         = array();

					if($count == 0) {
						return array(
							'data'      =>array(),
							'errorMsg'  =>'No se encontraron Registros',
							'successMsg'=>'',
							'success'   =>false
						);
					}

					foreach($result as $row):
						$row['id'] = $row['usuarioid'];
						$json[]=$row;
					endforeach;
					
					$dataToReturn = $json;
					$errorMsg     = "";
					$successMsg   = 'Exito';
					$success      =  true; 

					return array(
							'data'      =>$dataToReturn,
							'errorMsg'  =>$errorMsg,
							'successMsg'=>$successMsg, 
							'success'   =>$success
					);
			
			}catch(Exception $e){
					return array(
							'data'      =>array(),
							'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
							'successMsg'=>'',
							'success'   =>false
					);
			}
	}

	function saveUpdateUser($id, $username, $password, $name, $dni, $direccion, $telefono ,$tipo){
			try{
					$params = array();
					$SQL = "";
					if($id==null){
							// <-------INSERTAR USUARIO
							$SQL =
								"INSERT INTO usuario
									(username, password, nombre, dni, direccion, telefono, tipo)
								VALUES
									(?, ?, ?, ?, ?, ?, ?)";

							$password = password_hash($password,PASSWORD_DEFAULT);
							$params = array($username, $password, $name, $dni, $direccion, $telefono ,$tipo);

					}else{
							if($password==null){
									// <-------ACTUALIZACION DEL USUARIO
									$SQL =
									"UPDATE usuario SET
											username 	= ?,
											nombre 		= ?,
											dni 			= ?,
											direccion = ?,
											telefono 	= ?,
											tipo 			= ?
									WHERE usuarioid = ?";
									$params = array($username, $name, $dni, $direccion, $telefono ,$tipo, $id);

							}else{
									//<-------ACTUALIZACION DE CONTRASEÑA
									$SQL =
									"UPDATE usuario SET
											username 	= ?,
											password 	= ?,
											nombre 		= ?,
											dni 	    = ?,
											direccion = ?,
											telefono  = ?,
											tipo 	  	= ?
									WHERE usuarioid = ?";

									$password = password_hash($password,PASSWORD_DEFAULT);
									$params = array($username, $password, $name, $dni, $direccion, $telefono ,$tipo, $id);
							}
					}

					$result = fetchMySQL($SQL,'POST', $params);

					if(!$result) {
						return array(
							'data'      =>array(),
							'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
							'successMsg'=>'',
							'success'   =>false
						);
					}

					$dataToReturn = $params;
					$errorMsg     = "";
					$successMsg   = 'Exito';
					$success      = true;
					
					return array(
							'data'      =>$dataToReturn,
							'errorMsg'  =>$errorMsg,
							'successMsg'=>$successMsg, 
							'success'   =>$success
					);
			
			}catch(Exception $e){
					return array(
							'data'      =>array(),
							'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
							'successMsg'=>'',
							'success'   =>false
					);
			}
	}

	// CLIENT FUNTIONS -------------------->

	function getClients(){
		try{
			$SQL = 
				"SELECT 
					c.clienteid,
					c.nombre,
					c.dni,
					c.direccion,
					c.telefono, 
					c.mercadoid
				FROM cliente c
				";
				$result = fetchMySQL($SQL);

				$dataToReturn = array();
				$errorMsg     = "";
				$successMsg   = "";
				$success      = false;
				$count        = $result->num_rows;
				$json         = array();

				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				if($count == 0) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'No se encontraron Registros',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				foreach($result as $row):
					$row['id'] = $row['clienteid'];
					$json[]=$row;
				endforeach;
				
				$dataToReturn = $json;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      =  true;
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
				return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
				);
		}
	}

	function saveUpdateClient($id, $name, $dni, $direccion, $telefono ,$mercado){
		try{
			$params = array();
			$SQL  = "";
			if($id==null){
					// <-------INSERTAR CLIENTE
					$SQL =
						"INSERT INTO cliente
							(nombre, dni, direccion, telefono, mercadoid)
						VALUES
							(?, ?, ?, ?, ?)";

					$params = array($name, $dni, $direccion, $telefono ,$mercado);

			}else{
				// <-------ACTUALIZACION DEL CLIENTE
				$SQL =
				"UPDATE cliente SET
					nombre 		= ?,
					dni 		= ?,
					direccion 	= ?,
					telefono 	= ?,
					mercadoid 	= ?
				WHERE clienteid = ?";
				$params = array($name, $dni, $direccion, $telefono ,$mercado, $id);
			}

			$result = fetchMySQL($SQL,'POST', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}

			$dataToReturn = $params;
			$errorMsg     = "";
			$successMsg   = 'Exito';
			$success      = true;
			
			return array(
				'data'      =>$dataToReturn,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg, 
				'success'   =>$success
			);
		
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}

	// MERCADOS FUNTIONS -------------------->

	function getMercados(){
		try{
			$SQL = 
				"SELECT 
					m.mercadoid,
					m.descripcion
				FROM mercado m
				";
				$result = fetchMySQL($SQL);

				$dataToReturn = array();
				$errorMsg     = "";
				$successMsg   = "";
				$success      = false;
				$count        = $result->num_rows;
				$json         = array();

				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				if($count == 0) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'No se encontraron Registros',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				foreach($result as $row):
					$row['id'] = $row['mercadoid'];
					$json[]=$row;
				endforeach;
				
				$dataToReturn = $json;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      =  true;
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
				return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
				);
		}
	}

	function saveUpdateMercado($id, $descripcion){
		try{
				$conn = getConnection();
				$params = 1;
				$SQL  = "";
				if($id==null){
						// <-------INSERTAR MERCADO
						$SQL =
							"INSERT INTO mercado
								(descripcion)
							VALUES
								(?)";

						$params = array($descripcion);

				}else{
					// <-------ACTUALIZACION DEL MERCADO
					$SQL =
					"UPDATE mercado SET
						descripcion = ?
					WHERE mercadoid = ?";
					$params = array($descripcion, $id);
				}

				$result = fetchMySQL($SQL,'POST', $params);

				if(!$result) {
						return array(
								'data'      =>array(),
								'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
								'successMsg'=>'',
								'success'   =>false
						);
				}

				$dataToReturn = $params;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      = true;
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}

	// PRESTAMOS FUNTIONS -------------------->

	function getPrestamos(){
		try{
			$SQL = 
				"SELECT
					p.prestamoid,
					p.clienteid,
					p.mercadoid,
					p.monto,
					p.interes,
					p.total,
					p.nrocuotas,
					p.fechainiciopago,
					p.estado,
					p.fecharegistro,
					p.fechafinpago
				FROM prestamo p
				";
				$result = fetchMySQL($SQL);

				$dataToReturn = array();
				$errorMsg     = "";
				$successMsg   = "";
				$success      = false;
				$count        = $result->num_rows;
				$json         = array();

				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				if($count == 0) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'',
						'successMsg'=>'No se encontraron Prestamos',
						'success'   =>true
					);
				}

				foreach($result as $row):
					$row['id'] = $row['prestamoid'];
					$json[]=$row;
				endforeach;
				
				$dataToReturn = $json;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      =  true;
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
				return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
				);
		}
	}

	function saveUpdatePrestamo(
		$id, $tempid, $clienteid, $mercadoid, $monto, $interes,
		$total, $nrocuotas, $estado, $fechainiciopago, $fecharegistro){
		try{
			$successMsg   = '';
			$params = array();
			$SQL  = "";
			if($id==null){
				// <-------INSERTAR PRESTAMO
				$SQL =
					"INSERT INTO prestamo
						(tempid, clienteid, mercadoid, monto, interes,
						total, nrocuotas, estado, fechainiciopago, fecharegistro)
					VALUES
						(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

				$params = array(
					$tempid, $clienteid, $mercadoid, $monto, $interes,
					$total, $nrocuotas, $estado, $fechainiciopago, $fecharegistro
				);
				$successMsg = "Guardando Prestamos...";
			}else{
				// <-------ACTUALIZACION DEL PRESTAMO
				$SQL =
				"UPDATE prestamo SET
						estado = ?
				WHERE prestamoid = ?";
				$params = array($estado, $id);
			}
			
			$result = fetchMySQL($SQL,'POST', $params);

			// Recuperamos el ID generado
			$SQL =
			"SELECT 
				p.prestamoid as id,
				p.tempid
			FROM prestamo p
			WHERE tempid = ?";
			$params = array($tempid);

			$result = fetchMySQL($SQL,'GET', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}

			$dataToReturn = array();
			$errorMsg     = "";
			$success      = false;
			
			if($result->num_rows >= 1){
				foreach ($result as $row):
					$dataToReturn = array(
						'id' 	 => $row['id'],
						'tempid' => $row['tempid']
					);
				endforeach;
				$success = true;
			}

			return array(
				'data'      =>$dataToReturn,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg, 
				'success'   =>$success
			);
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}

	function getCuotas(){
		try{
			$SQL = 
				"SELECT 
					c.cuotaid,
					c.prestamoid,
					c.numerocuota,
					c.fechacuota,
					c.fechapagocuota,
					c.estado,
					c.fecharegistro,
					c.estado,
					c.monto,
					c.montoefectivo,
					c.montotransferencia,
					c.montoyape,
					c.montoplin	
				FROM cuota c
				";
				$result = fetchMySQL($SQL);

				$dataToReturn = array();
				$errorMsg     = "";
				$successMsg   = "";
				$success      = false;
				$count        = $result->num_rows;
				$json         = array();

				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				if($count == 0) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'',
						'successMsg'=>'No se encontraron Cuotas',
						'success'   =>true
					);
				}

				foreach($result as $row):
					$row['id'] = $row['cuotaid'];
					$json[]=$row;
				endforeach;
				
				$dataToReturn = $json;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      =  true;
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
				return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
				);
		}
	}

	function saveUpdateCuotas($cuotas, $prestamoid){
		try{
			$count = 0;
			$params = array();
			$SQL = "";

			$dataToReturn = array();
			$errorMsg     = "";
			$successMsg   = "";
			$success      = false;

			foreach($cuotas as $row):
				$SQL =
					"INSERT INTO cuota
						(prestamoid, numerocuota, monto, fechacuota, estado, fecharegistro)
					VALUES
						(?, ?, ?, ?, ?, ?)";

				$params = array(
					$prestamoid,
					$row['numerocuota'], 
					$row['monto'],
					$row['fechacuota'],
					$row['estado'],
					$row['fecharegistro']
				);

				$result = fetchMySQL($SQL,'POST', $params);

				if(!$result){
				}else{
					$count++;
					$result = false;
				}
			endforeach;

			if($count==count($cuotas)){
				$SQL =
				"UPDATE prestamo
					SET estado = 2
				WHERE
					prestamoid = ?";
				$params = array($prestamoid);

				$result = fetchMySQL($SQL, 'POST', $params);

				// Recuperamos las cuotas generado
				$SQL =
				"SELECT 
					c.cuotaid,
					c.cuotaid as id,
					c.prestamoid,
					c.numerocuota,
					c.monto,
					c.fechacuota,
					c.estado,
					c.fecharegistro
				FROM cuota c
				WHERE prestamoid = ?";
				$params = array($prestamoid);

				$result = fetchMySQL($SQL,'GET', $params);

				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
					);
				}

				$successMsg = "Prestamo Generado con Exito";
				$errorMsg   = "";
				$success    = true;
				
				if($result->num_rows >= 1){
					foreach ($result as $row):
						$dataToReturn[] = $row;
					endforeach;
				}
			}else{
				$result = false;
			}

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}
			
			return array(
					'data'      =>$dataToReturn,
					'errorMsg'  =>$errorMsg,
					'successMsg'=>$successMsg, 
					'success'   =>$success
			);
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}

	function payCuota($prestamoid, $prestamoestado, $cuota, $montopendiente, $cuotapendienteid){
		try{
			$successMsg   = '';
			$params = array();

			$id 				= $cuota['id'];
			$estado 			= $cuota['estado'];
			$monto 				= $cuota['monto'];
			$fechapagocuota 	= $cuota['fechapagocuota'];
			$montoefectivo 		= $cuota['montoefectivo'];
			$montotransferencia = $cuota['montotransferencia'];
			$montoyape 			= $cuota['montoyape'];
			$montoplin 			= $cuota['montoplin'];

			// <-------FINALIZACION DEL ESTADO DEL PRESTAMO
			if($prestamoestado==3){
				$SQL =
				"UPDATE prestamo SET
					estado = ?,
					fechafinpago = ?
				WHERE prestamoid = ?";
				$params = array($prestamoestado, $fechapagocuota, $prestamoid);
				
				$result = fetchMySQL($SQL,'POST', $params);
				
				if(!$result) {
					return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, al actualizar el prestamo',
						'successMsg'=>'',
						'success'   =>false
					);
				}
			}

			// <-------ACTUALIZACION CUOTA SALDO (Ultima Cuota)
			$SQL =
			"UPDATE cuota SET
				monto = monto + ?
			WHERE cuotaid = ?";
			$params = array($montopendiente, $cuotapendienteid);
			
			$result = fetchMySQL($SQL,'POST', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}
			
			// <-------ACTUALIZACION DE LA CUOTA
			$SQL =
			"UPDATE cuota SET
				estado = ?,
				monto = ?,
				fechapagocuota = ?,
				montoefectivo = ?,
				montotransferencia = ?,
				montoyape = ?,
				montoplin = ?
			WHERE cuotaid = ?";
			$params = array(
				$estado, $monto, $fechapagocuota,
				$montoefectivo, $montotransferencia,
				$montoyape, $montoplin, $id);
			
			$result = fetchMySQL($SQL,'POST', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}
			
			$dataToReturn = $params;
			$errorMsg     = "";
			$successMsg   = 'Exito';
			$success      = true;
			
			return array(
				'data'      =>$dataToReturn,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg, 
				'success'   =>$success
			);
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}

	function updateCuotaAjuste($cuotaid, $monto, $prestamoid, $interes, $total){
		try{
			$successMsg   = '';
			$params = array();

			// <-------ACTUALIZACION CUOTA AJUSTE (Penultima Cuota)
			$SQL =
			"UPDATE cuota SET
				monto = ?
			WHERE cuotaid = ?";
			$params = array($monto, $cuotaid);
			
			$result = fetchMySQL($SQL,'POST', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}
			
			// <-------ACTUALIZACION DE LA CUOTA
			$SQL =
			"UPDATE prestamo SET
				interes = ?,
				total = ?
			WHERE prestamoid = ?";
			$params = array($interes, $total, $prestamoid);
			
			$result = fetchMySQL($SQL,'POST', $params);

			if(!$result) {
				return array(
					'data'      =>array(),
					'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
					'successMsg'=>'',
					'success'   =>false
				);
			}
			
			$dataToReturn = $params;
			$errorMsg     = "";
			$successMsg   = 'Exito';
			$success      = true;
			
			return array(
				'data'      =>$dataToReturn,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg, 
				'success'   =>$success
			);
		}catch(Exception $e){
			return array(
				'data'      =>array(),
				'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
				'successMsg'=>'',
				'success'   =>false
			);
		}
	}


	function getSucursales(){
		try{
				$conn = getConnection();
				$SQL = "
						SELECT 
								s.[id] as id_sucursal,
								s.[codigo_sucursal]
						FROM  sucursales s";

				$result = sqlsrv_query($conn, $SQL);

				$dataToReturn = array();
				$errorMsg     = "";
				$successMsg   = "";
				$success      = false;
				$count        = 0;
				$json         = array();

				if( $result === false) {
						return array(
								'data'      =>array(),
								'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
								'successMsg'=>'',
								'success'   =>false
						);
				}
				
				while($row = sqlsrv_fetch_object($result)){
						$count ++;
						if(property_exists($row,'id_sucursal'    )){ $resultado['id_sucursal']     = $row->id_sucursal;};
						if(property_exists($row,'codigo_sucursal')){ $resultado['codigo_sucursal'] = $row->codigo_sucursal;};
						$json[]=$resultado;
				}

				$dataToReturn = $json;
				$errorMsg     = "";
				$successMsg   = 'Exito';
				$success      = true; 

				if($count == 0) {
						$dataToReturn = array();
						$errorMsg   ='No se encontraron Registros';
						$successMsg = "";
						$success    = false;
				}
				
				return array(
						'data'      =>$dataToReturn,
						'errorMsg'  =>$errorMsg,
						'successMsg'=>$successMsg, 
						'success'   =>$success
				);
		
		}catch(Exception $e){
				return array(
						'data'      =>array(),
						'errorMsg'  =>'Algo salio mal, por favor vuelva a intentarlo',
						'successMsg'=>'',
						'success'   =>false
				);
		}
	}

?>