<?php
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
	header("Content-Type: text/html; charset=utf-8");

	require './userLoggedMOD.php';
	$method = $_SERVER['REQUEST_METHOD'];

	$data = json_decode(file_get_contents('php://input'), true);
	$action = $data['action'];

	// VERIFICAR TOKEN MEDIANTE FUNCION REUTILIZABLE
	$headers = getallheaders();
	$auth = null;
	if(isset($_SERVER["HTTP_AUTHORIZATION"])){
			$auth = $_SERVER["HTTP_AUTHORIZATION"];
	}
	if(isset($headers["Authorization"])){
			$auth = $headers["Authorization"];
	}
	$tokenData = verifyToken($auth);
	if($tokenData == false){
		print(json_encode(array(
			'data'      =>array(),
			'status'    =>401,
			'errorMsg'  =>'Acceso Denegado',
			'successMsg'=>''
			)));
		return;
	};

	switch ($action){

		case 'getUsers':
			$result  	= getUsers();
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'saveUpdateUser':
			$queryData = array(
				$data['id'],
				$data['username'],
				$data['password'],
				$data['nombre'],
				$data['dni'],
				$data['direccion'],
				$data['telefono'],
				$data['tipo'],
			);
			$result	  = saveUpdateUser(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'getClients':
			$result  = getClients();
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'saveUpdateClient':
			$queryData = array(
				$data['id'],
				$data['nombre'],
				$data['dni'],
				$data['direccion'],
				$data['telefono'],
				$data['mercadoid'],
			);
			$result   = saveUpdateClient(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response)); 
		break;
		
		case 'getMercados':
			$result  	= getMercados();
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'saveUpdateMercado':
			$queryData = array(
				$data['id'],
				$data['descripcion'],
			);
			$result   = saveUpdateMercado(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'getPrestamos':
			$result  = getPrestamos();
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'saveUpdatePrestamo':
			$queryData = array(
				$data['id'],
				$data['tempid'],
				$data['clienteid'],
				$data['mercadoid'],
				$data['monto'],
				$data['interes'],
				$data['total'],
				$data['nrocuotas'],
				$data['estado'],
				$data['fechainiciopago'],
				$data['fecharegistro'],
			);
			$result   = saveUpdatePrestamo(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response)); 
		break;

		case 'getCuotas':
			$result  = getCuotas();
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'saveUpdateCuotas':
			$queryData = array(
				$data['cuotas'],
				$data['prestamoid']
			);
			$result   = saveUpdateCuotas(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'payCuota':
			$queryData = array(
				$data['prestamoid'],
				$data['prestamoestado'],
				$data['cuota'],
				$data['montopendiente'],
				$data['cuotapendienteid']
			);
			$result   = payCuota(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'updateCuotaAjuste':
			$queryData = array(
				$data['cuotaid'],
				$data['monto'],
				$data['prestamoid'],
				$data['interes'],
				$data['total']
			);
			$result   = updateCuotaAjuste(...$queryData);
			$response = makeResponse($result);
			print(json_encode($response));
		break;

		case 'getSucursales':

			$sucursales = getSucursales();
			$data       = $sucursales['data'];
			$errorMsg   = $sucursales['errorMsg'];
			$successMsg = $sucursales['successMsg'];
			$success    = $sucursales['success'];
			$status     = 400;
						
			if($success){
				$status = 200;
			}else{
				$status = 400;
			}
			print(json_encode(array(
				'data'      =>$data,
				'status'    =>$status,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg
			)));
		
		break;

		case 'getCheques':

			$fecha_ini = null;
			$fecha_fin = null;

			if(isset($data['fecha_ini'])){
					$fecha_ini = $data['fecha_ini'];
				}
			if(isset($data['fecha_fin'])){
					$fecha_fin = $data['fecha_fin'];
			}

			$cheques    = getCheques($fecha_ini, $fecha_fin);
			$data       = $cheques['data'];
			$errorMsg   = $cheques['errorMsg'];
			$successMsg = $cheques['successMsg'];
			$success    = $cheques['success'];
			$status     = 400;
			
			if($success){
					$status = 200;
			}else{
					$status = 400;
			}
			print(json_encode(array(
				'data'      =>$data,
				'status'    =>$status,
				'errorMsg'  =>$errorMsg,
				'successMsg'=>$successMsg
			)));
			
		break;

		


	}		

?>